/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.LinkedList;
import java.util.Random;
import oracle.ldap.util.QClosedException;
import oracle.ldap.util.WorkQueue;

public class WorkQueue {
    private static final int DEFAULT_MAX_PRIORITY = 1;
    private int m_nMaxPriority = 1;
    private LinkedList m_queue = null;
    private boolean m_qClosed = false;
    private int m_nThrEnQWaitCnt = 0;
    private int m_nThrDeQWaitCnt = 0;
    private int m_nMaxElements = -1;
    private int m_nElemCnt = 0;

    public WorkQueue() {
        this.initQ(-1, 1);
    }

    public WorkQueue(int n) {
        this.initQ(-1, n);
    }

    public WorkQueue(int n, int n2) {
        this.initQ(n, n2);
    }

    private void initQ(int n, int n2) {
        Object e = null;
        if (0 >= n && n != -1) {
            throw new IllegalArgumentException("VALUE_NOT_IN_RANGE");
        }
        if (0 >= n2) {
            throw new IllegalArgumentException("VALUE_NOT_IN_RANGE");
        }
        this.m_nMaxElements = n;
        this.m_nMaxPriority = n2;
        this.m_queue = new LinkedList();
        this.m_qClosed = false;
        int n3 = 0;
        while (n3 < n2) {
            this.m_queue.addLast(e);
            ++n3;
        }
    }

    private void addToQ(Object object, int n) {
        LinkedList<Object> linkedList = (LinkedList<Object>)this.m_queue.get(n - 1);
        if (null == linkedList) {
            linkedList = new LinkedList<Object>();
            this.m_queue.add(n - 1, linkedList);
        }
        linkedList.addLast(object);
        ++this.m_nElemCnt;
    }

    private Object removeFromQ() {
        Object var1_1 = null;
        int n = this.m_nMaxPriority - 1;
        while (n >= 0) {
            LinkedList linkedList = (LinkedList)this.m_queue.get(n);
            if (null != linkedList && !linkedList.isEmpty()) {
                var1_1 = linkedList.removeFirst();
                --this.m_nElemCnt;
                break;
            }
            --n;
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void enqueue(Object var1_1, int var2_2) throws QClosedException {
        if (null == var1_1) {
            throw new IllegalArgumentException("CANNOT_PASS_NULL_ARGUMENT");
        }
        if (var2_2 <= 0 || var2_2 > this.m_nMaxPriority) {
            throw new IllegalArgumentException("VALUE_NOT_IN_RANGE");
        }
        if (!this.m_qClosed) ** GOTO lbl16
        throw new QClosedException("Q_CLOSED");
lbl-1000:
        // 1 sources

        {
            try {
                ++this.m_nThrEnQWaitCnt;
                this.wait();
                --this.m_nThrEnQWaitCnt;
            }
            catch (InterruptedException var3_3) {
                var3_3.printStackTrace();
            }
            if (!this.m_qClosed) continue;
            throw new QClosedException("Q_CLOSED");
lbl16:
            // 2 sources

            ** while (this.isFull())
        }
lbl17:
        // 1 sources

        this.addToQ(var1_1, var2_2);
        this.notifyAll();
    }

    public void enqueue(Object object) throws QClosedException {
        this.enqueue(object, 1);
    }

    public synchronized boolean enqueueNoWait(Object object, int n) throws QClosedException {
        boolean bl = false;
        if (null == object) {
            throw new IllegalArgumentException("CANNOT_PASS_NULL_ARGUMENT");
        }
        if (n <= 0 || n > this.m_nMaxPriority) {
            throw new IllegalArgumentException("VALUE_NOT_IN_RANGE");
        }
        if (this.m_qClosed) {
            throw new QClosedException("Q_CLOSED");
        }
        if (!this.isFull()) {
            this.addToQ(object, n);
            this.notifyAll();
            bl = true;
        }
        return bl;
    }

    public void enqueueNoWait(Object object) throws QClosedException {
        this.enqueueNoWait(object, 1);
    }

    public synchronized Object dequeue() throws QClosedException {
        Object object = null;
        while (this.isEmpty()) {
            if (this.m_qClosed) {
                throw new QClosedException("Q_EMPTY_AND_CLOSED");
            }
            try {
                ++this.m_nThrDeQWaitCnt;
                this.wait();
                --this.m_nThrDeQWaitCnt;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        object = this.removeFromQ();
        this.notifyAll();
        return object;
    }

    public synchronized Object dequeueNoWait() throws QClosedException {
        Object object = null;
        if (this.isEmpty() && this.m_qClosed) {
            throw new QClosedException("Q_EMPTY_AND_CLOSED");
        }
        object = this.removeFromQ();
        return object;
    }

    public synchronized void close() {
        this.m_qClosed = true;
        this.notifyAll();
    }

    public synchronized boolean isEmpty() {
        return 0 == this.m_nElemCnt;
    }

    public synchronized boolean isFull() {
        return this.m_nMaxElements == this.m_nElemCnt;
    }

    public synchronized int getSize() {
        return this.m_nElemCnt;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(string).append("Queue Statistics").append(string).append("----------------").append(string).append("# max elements  : ").append(this.m_nMaxElements).append(string).append("# elements in Q : ").append(this.m_nElemCnt).append(string).append("# of EnQ wait T : ").append(this.m_nThrEnQWaitCnt).append(string).append("# of DeQ wait T : ").append(this.m_nThrDeQWaitCnt).append(string).append(string);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Thread thread;
        int n = 1;
        int n2 = 1;
        int n3 = -1;
        if (stringArray.length < 2) {
            System.out.println("Usage: java oracle.ldap.util.WorkQueue <#Producers> <#Consumers> [Buffer Size]");
            System.exit(0);
        }
        n = Integer.parseInt(stringArray[0]);
        n2 = Integer.parseInt(stringArray[1]);
        if (stringArray.length >= 3) {
            n3 = Integer.parseInt(stringArray[2]);
        }
        System.out.println("Number of Producers: " + n);
        System.out.println("number of Consumers: " + n2);
        System.out.println("Buffer size: " + n3);
        WorkQueue workQueue = new WorkQueue(n3, 1);
        int n4 = 1;
        while (n4 <= n) {
            class Producer
            extends Thread {
                private WorkQueue buffer;
                private int number;

                Producer(String string, WorkQueue workQueue) {
                    super(string);
                    this.buffer = workQueue;
                    this.number = 1;
                }

                public void run() {
                    while (true) {
                        System.out.println(this.getName() + " - Produced " + this.number);
                        try {
                            this.buffer.enqueue(this.number + " from " + this.getName(), 1);
                            ++this.number;
                        }
                        catch (QClosedException qClosedException) {
                            qClosedException.printStackTrace();
                            System.out.println("Seizing to produce .....");
                            break;
                        }
                        try {
                            Random random = new Random();
                            Thread.sleep((int)(-1.0 * Math.log(random.nextDouble())));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            thread = new Producer("Producer - " + n4, workQueue);
            thread.start();
            ++n4;
        }
        n4 = 1;
        while (n4 < 5) {
            System.out.println(workQueue);
            ++n4;
        }
        n4 = 1;
        while (n4 <= n2) {
            class Consumer
            extends Thread {
                private WorkQueue buffer;

                Consumer(String string, WorkQueue workQueue) {
                    super(string);
                    this.buffer = workQueue;
                }

                public void run() {
                    while (true) {
                        String string = null;
                        try {
                            string = (String)this.buffer.dequeue();
                            System.out.println(this.getName() + " - Consumed " + string);
                        }
                        catch (QClosedException qClosedException) {
                            qClosedException.printStackTrace();
                            System.out.println("Seizing to consume.....");
                            break;
                        }
                        try {
                            Random random = new Random();
                            Thread.sleep((int)(-1.0 * Math.log(random.nextDouble())));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            thread = new Consumer("Consumer - " + n4, workQueue);
            thread.start();
            ++n4;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        workQueue.close();
    }
}

